/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.menu;

import com.lunazstudios.cobblefurnies.block.entity.FurniCrafterBlockEntity;
import com.lunazstudios.cobblefurnies.network.message.SyncCraftableRecipesMessage;
import com.lunazstudios.cobblefurnies.recipe.CountedIngredient;
import com.lunazstudios.cobblefurnies.recipe.FurniCraftingRecipe;
import com.lunazstudios.cobblefurnies.registry.CFMenus;
import com.lunazstudios.cobblefurnies.registry.CFRecipes;
import dev.architectury.networking.NetworkManager;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_8710;
import net.minecraft.class_8786;

public class FurniCrafterMenu
extends class_1703 {
    private final class_3914 access;
    private final class_1657 player;
    private final class_1937 level;
    private final FurniCrafterBlockEntity blockEntity;
    private final class_1277 outputContainer;
    private List<class_8786<FurniCraftingRecipe>> availableRecipes;
    private List<Boolean> canCraftRecipes;
    private static final int OUTPUT_SLOT_INDEX = 0;

    public FurniCrafterMenu(int id, class_1661 inventory, class_1937 level, class_2338 pos, class_1277 outputContainer) {
        super(CFMenus.FURNI_CRAFTER_MENU.get(), id);
        FurniCrafterBlockEntity entity;
        this.access = class_3914.method_17392((class_1937)level, (class_2338)pos);
        this.player = inventory.field_7546;
        this.level = level;
        class_2586 class_25862 = level.method_8321(pos);
        this.blockEntity = class_25862 instanceof FurniCrafterBlockEntity ? (entity = (FurniCrafterBlockEntity)class_25862) : null;
        this.outputContainer = outputContainer;
        this.fetchAvailableRecipes();
        this.addPlayerInventorySlots(inventory);
        this.addOutputSlot();
        this.updateCraftableRecipes();
    }

    public FurniCrafterMenu(int id, class_1661 inventory, class_1937 level, class_2338 pos) {
        this(id, inventory, level, pos, new class_1277(1));
    }

    public FurniCrafterMenu(int id, class_1661 inventory, class_2540 buf) {
        this(id, inventory, inventory.field_7546.method_37908(), buf.method_10811(), new class_1277(1));
    }

    public FurniCrafterMenu(int id, class_1661 inventory) {
        this(id, inventory, inventory.field_7546.method_37908(), class_2338.field_10980, new class_1277(1));
    }

    public void method_7623() {
        super.method_7623();
        this.updateCraftableRecipes();
    }

    public void updateCraftableRecipes() {
        this.canCraftRecipes = this.availableRecipes.stream().map(r -> this.canCraft((FurniCraftingRecipe)r.comp_1933())).collect(Collectors.toList());
        this.syncCraftableRecipesToClient();
    }

    private void syncCraftableRecipesToClient() {
        class_1657 class_16572 = this.player;
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)class_16572;
        boolean[] craftable = new boolean[this.canCraftRecipes.size()];
        for (int i = 0; i < this.canCraftRecipes.size(); ++i) {
            craftable[i] = this.canCraftRecipes.get(i);
        }
        SyncCraftableRecipesMessage message = new SyncCraftableRecipesMessage(this.field_7763, craftable);
        NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_8710)message);
    }

    private void fetchAvailableRecipes() {
        this.availableRecipes = this.level.method_8433().method_30027(CFRecipes.FURNI_CRAFTING_RECIPE_TYPE).stream().sorted(Comparator.comparing(class_8786::comp_1932)).collect(Collectors.toList());
    }

    public List<class_8786<FurniCraftingRecipe>> getAvailableRecipes() {
        return this.availableRecipes;
    }

    public boolean canCraft(FurniCraftingRecipe recipe) {
        for (CountedIngredient ci : recipe.getMaterials()) {
            int requiredCount = ci.count();
            int totalCount = 0;
            for (class_1799 stack : this.player.method_31548().field_7547) {
                if (stack.method_7960() || !ci.ingredient().method_8093(stack)) continue;
                totalCount += stack.method_7947();
            }
            if (totalCount >= requiredCount) continue;
            return false;
        }
        return true;
    }

    private void addPlayerInventorySlots(class_1661 inventory) {
        int yOffset = 38;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735((class_1263)inventory, col + row * 9 + 9, 8 + col * 18, 84 + yOffset + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.method_7621(new class_1735((class_1263)inventory, col, 8 + col * 18, 142 + yOffset));
        }
    }

    private void addOutputSlot() {
        this.method_7621(new class_1735(this, (class_1263)this.outputContainer, 0, 149, 86){

            public boolean method_7680(class_1799 stack) {
                return false;
            }
        });
    }

    public void craftSelectedRecipe(int recipeIndex) {
        if (recipeIndex < 0 || recipeIndex >= this.availableRecipes.size() || this.blockEntity == null) {
            return;
        }
        class_8786<FurniCraftingRecipe> recipeHolder = this.availableRecipes.get(recipeIndex);
        FurniCraftingRecipe recipe = (FurniCraftingRecipe)recipeHolder.comp_1933();
        if (!this.canCraft(recipe)) {
            return;
        }
        class_1799 result = recipe.method_8110(null);
        class_1799 outputSlot = this.outputContainer.method_5438(0);
        if (!(outputSlot.method_7960() || outputSlot.method_31574(result.method_7909()) && outputSlot.method_7947() + result.method_7947() <= outputSlot.method_7914())) {
            return;
        }
        for (CountedIngredient ci : recipe.getMaterials()) {
            this.removeItemsFromInventory(ci);
        }
        if (outputSlot.method_7960()) {
            this.outputContainer.method_5447(0, result.method_7972());
        } else {
            outputSlot.method_7933(result.method_7947());
        }
    }

    private void removeItemsFromInventory(CountedIngredient ci) {
        int requiredCount;
        int remaining = requiredCount = ci.count();
        for (int i = 0; i < this.player.method_31548().field_7547.size(); ++i) {
            class_1799 stack = (class_1799)this.player.method_31548().field_7547.get(i);
            if (stack.method_7960() || !ci.ingredient().method_8093(stack)) continue;
            int take = Math.min(stack.method_7947(), remaining);
            stack.method_7934(take);
            if ((remaining -= take) <= 0) break;
        }
    }

    public class_1799 method_7601(class_1657 player, int i) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return (Boolean)this.access.method_17396((level, pos) -> level.method_8321(pos) instanceof FurniCrafterBlockEntity, (Object)true);
    }

    public void setCraftableRecipes(boolean[] canCraft) {
        for (int i = 0; i < canCraft.length && i < this.canCraftRecipes.size(); ++i) {
            this.canCraftRecipes.set(i, canCraft[i]);
        }
    }

    public boolean hasMaterials(CountedIngredient material, Map<Integer, Integer> counted) {
        int required = material.count();
        for (class_1799 stack : this.player.method_31548().field_7547) {
            if (stack.method_7960() || !material.ingredient().method_8093(stack)) continue;
            int key = stack.method_7909().hashCode();
            int alreadyUsed = counted.getOrDefault(key, 0);
            int available = stack.method_7947() - alreadyUsed;
            if (available <= 0) continue;
            int used = Math.min(required, available);
            counted.put(key, alreadyUsed + used);
            if ((required -= used) > 0) continue;
            return true;
        }
        return false;
    }
}

